﻿$(document).on("pageinit", function () {
    var context = $("[data-questiontype='autocomplete']");

    $(".autocomplete-item", context).on("click", function () {
        var container = $(this).closest(".questionContent");
        var value = $(this).attr("data-value");
        var text = $(this).text();
        $(".ui-input-search input", container).val(text);
        $("input[type=hidden]", context).val(value).trigger("change");
        $("ul li:not(.ui-screen-hidden)", container).addClass("ui-screen-hidden");
    });

    $(".ui-input-search input", context).on("change", function () {
        var list = $("ul", context);
        var value = getValueFromText(list, $(this).val());
        var invalidAsOpenEnd = list.attr("data-invalidasopenend");
        
        if (value == null) {
            $(this).val("");
        }

        $("input[type=hidden]", context).val(value).trigger("change");
    });

    $("ul", context).each(function () {
        var container = $(this).closest(".questionContent");
        var value = $("input[type=hidden]", container).val();
        var text = getTextFromValue($(this), value);
        $(".ui-input-search input", container).val(text);
    });

    $(".autocomplete-item.softPromptChoice").hide();
});

function getValueFromText(list, text) {
    var invalidAsOpenEnd = list.attr("data-invalidasopenend");
    var value = (invalidAsOpenEnd == "True" ? text : null);
    var regexp = new RegExp("^" + text + "$", "i");

    $("li", list).each(function () {
        if ($(this).find("a").text().match(regexp)) {
            value = $(this).attr("data-value");
            $("li:not(.ui-screen-hidden)", list).addClass("ui-screen-hidden");
            return false;
        }
    });

    return value;
}

function getTextFromValue(list, value) {
    var text;

    if (value) {
        text = $("li[data-value=" + value + "] a", list).text();
    }

    if (!text) {
        text = value;
    }

    return text;
}